﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminListInactive.aspx.cs" Inherits="AdminListInactive" Title="" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <p>
        <asp:GridView ID="GridViewPolyTraumaEntries" runat="server" Width="90%" 
            AutoGenerateColumns="False" 
            Summary="This table is a list of Inactive Polytrauma entries.  Column headers are clickable to sort and reverse sort the table by that column."
            DataSourceID="ObjectDataSourcePolyTraumaEntries"
            AllowPaging="True" AllowSorting="True"
            DataKeyNames="TBI_POLYTRAUMA_ID">
            <Columns>
                <asp:BoundField  DataField="TBI_POLYTRAUMA_ID"
                    HeaderText="ID" SortExpression="TBI_POLYTRAUMA_ID"  >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" Width="20px" />
                </asp:BoundField>

                <asp:TemplateField HeaderText="SSN" SortExpression="Snum" 
                    AccessibleHeaderText="SSN">
                    <ItemTemplate>
                        <asp:Label ID="LabelSSN" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Snum"))) %>'></asp:Label>        
                    
                    </ItemTemplate>         
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Patient Name" SortExpression="LAST_NAME">
                   <ItemTemplate>
                        <asp:Label ID="LabelPatientLastName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME"))) %>'></asp:Label>,&nbsp;
                        <asp:Label ID="LabelPatientFirstName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME"))) %>'></asp:Label>
                        <asp:Label ID="LabelPatientMiddleName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("MIDDLE_NAME"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left" Width="200px" />
                </asp:TemplateField>
                    
                <asp:TemplateField HeaderText="MTF / Referral Source" SortExpression="STD_TBIFACILITYSRC.NAME">
                    <ItemTemplate>
                        <asp:Label ID="LabelReferallSource" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_TBIFACILITYSRC.NAME"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left" Width="120px" />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Polytrauma VAMC" SortExpression="STD_INSTITUTION1.VISN_ID">
                    <ItemTemplate>
                        (<asp:Label ID="LabelVamcVisn" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.STD_INSTITUTION_PARENT.NAME"))) %>'></asp:Label>)
                        (<asp:Label ID="LabelVamcStationNumber" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.STATIONNUMBER"))) %>'></asp:Label>)
                        <asp:Label ID="LabelVamcVistaName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.VISTANAME"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left"  />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Injury Date" SortExpression="TBI_INJURY_DATE">
                    <ItemTemplate>
                        <asp:Label ID="LabelInjuryDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TBI_INJURY_DATE","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" Width="70px" />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Last Updated" SortExpression="UPDATED">
                    <ItemTemplate>
                        <asp:Label ID="LabelReferralDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("UPDATED","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" Width="70px" />
                </asp:TemplateField>
                
                <asp:TemplateField >
                    <ItemTemplate>
                        <asp:Button ID="btnSelect" runat="server" Text="Select" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TBI_POLYTRAUMA_ID"))) %>' OnClick="btnSelect_Click" />&nbsp;
                        <asp:Button ID="btnRestore" runat="server" Text="Restore" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TBI_POLYTRAUMA_ID"))) %>' OnClick="btnRestore_Click" />&nbsp;
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" Width="200px" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <br />

        <asp:ObjectDataSource ID="ObjectDataSourcePolyTraumaEntries" runat="server" 
            SelectMethod="SelectInactive" 
            SelectCountMethod="SelectInactiveCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManager.TBI.PolyTraumaEntriesManager">
            <SelectParameters>
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
           
        <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />
    </p>
</asp:Content>

